#include <stdio.h>
#include <inttypes.h>
#include "lite-qmi-wds.h"
#include "wds.h"


void DisplayGetApnMsisdnInfo(unpack_wds_ApnMsisdnInfo_t *pApnMsisdnInfo)
{
	printf("\n  APN Msisdn Info List:\n");
	printf("\n  Number Number of MSISDN: %d", pApnMsisdnInfo->num_msisdn);

	for (int idx = 0; idx < pApnMsisdnInfo->num_msisdn; ++idx)
	{
		printf("  Msisdn[%d]: %d\n", idx, *pApnMsisdnInfo->pMsisdn);
		++pApnMsisdnInfo->pMsisdn;
	}	
}

void DisplayApnOpReservedPcoList(unpack_wds_ApnOpReservedPcoList_t *pApnOpReservedPcoList)
{
	printf("\n  APN Op Reserved Pco List:\n");
	printf("\n  Number of APN Op Reserved Pco List: %d", pApnOpReservedPcoList->numInstances);
	WdsApnOpReservedPco_t *pWdspApnOpReservedPcoList = pApnOpReservedPcoList->pWdsApnOpReservedPcoList;
	for (int idx = 0; idx < pApnOpReservedPcoList->numInstances; ++idx)
	{
		printf("\n  PcoId[%d]: %d\n", idx, pWdspApnOpReservedPcoList->PcoId);
		printf("  MCC[%d]: %d\n", idx, pWdspApnOpReservedPcoList->Mcc);
		printf("  MNC[%d]: %d\n", idx, pWdspApnOpReservedPcoList->Mnc);
		printf("  MncIncludesPcsDigit[%d]: %d\n", idx, pWdspApnOpReservedPcoList->MncIncludesPcsDigit);
		
		printf("  AppSpecificInfoLength[%d]: %d\n", idx, pWdspApnOpReservedPcoList->AppSpecificInfoLength);
		for(int idy = 0; idy < pWdspApnOpReservedPcoList->AppSpecificInfoLength; ++idy)
			printf("  pWdspApnOpReservedPcoList[%d].AppSpecificInfoLength[%d]: %d\n", idx, idy, pWdspApnOpReservedPcoList->AppSpecificInfo[idy]);

		printf("\n  ContainerId[%d]: %d\n", idx, pWdspApnOpReservedPcoList->ContainerId); 
	}	
}

void DisplayLteAttachParamsIndication(unpack_wds_SLQSLteAttachParams_ind_t *pLteAttachParams_ind)
{
	printf("\n  Lte Attach Params Indication:\n");
	printf("  pLteAttachParams_ind->AttachParamValidTlv: %d\n", pLteAttachParams_ind->AttachParamValidTlv); 

	if (pLteAttachParams_ind->AttachParamValidTlv)
	{
		if (swi_uint256_get_bit (pLteAttachParams_ind->ParamPresenceMask, 0x10))
			printf("\n  Apn Name: %s", pLteAttachParams_ind->pApnString);

		if (swi_uint256_get_bit (pLteAttachParams_ind->ParamPresenceMask, 0x11))
			printf("    Ip Type: %d", *pLteAttachParams_ind->pIp_Type);
		
		if (swi_uint256_get_bit (pLteAttachParams_ind->ParamPresenceMask, 0x12))
			printf("    IPv4 Address: %d", *pLteAttachParams_ind->pIPv4Address);
		
		if (swi_uint256_get_bit (pLteAttachParams_ind->ParamPresenceMask, 0x13))
			printf("    IPv4 Gateway Address: %d", *pLteAttachParams_ind->pIPv4GatewayAddress);
		
		if (swi_uint256_get_bit (pLteAttachParams_ind->ParamPresenceMask, 0x14))
			printf("    IPv4 Subnet Mask: %d", *pLteAttachParams_ind->pIPv4SubnetMask);
		
		if (swi_uint256_get_bit (pLteAttachParams_ind->ParamPresenceMask, 0x15))
		{
			printf("    Ipv6 Address Length: %d", pLteAttachParams_ind->pIpv6Address->Ipv6_prefix_length);
			for (int idx = 0; idx < pLteAttachParams_ind->pIpv6Address->Ipv6_prefix_length; ++idx)
				printf("    Ipv6 Address [%d]: %d", idx, pLteAttachParams_ind->pIpv6Address->Ipv6_address[idx]);
		}		
		if (swi_uint256_get_bit (pLteAttachParams_ind->ParamPresenceMask, 0x16))
		{
			printf("    Ipv6 Gateway Address Length: %d", pLteAttachParams_ind->pIpv6GatewayAddress->Ipv6_prefix_length);
			for (int idx = 0; idx < pLteAttachParams_ind->pIpv6GatewayAddress->Ipv6_prefix_length; ++idx)
				printf("    Ipv6 Gateway Address[%d]: %d", idx, pLteAttachParams_ind->pIpv6GatewayAddress->Ipv6_address[idx]);
		}
	}
}

void DisplayApnOpReservedPcoListChangeIndication(unpack_wds_SLQSApnOpReservedPcoListChange_ind_t *pApnOpReservedPcoListChange_ind)
{
	uint8_t      *pAppSpecificInfo;
	printf("\n  APN Operator Reserved PCO List Change Indication\n");
	printf("    Apn Name: %s", pApnOpReservedPcoListChange_ind->apn_name);

	printf("  PCO Count:  %d", pApnOpReservedPcoListChange_ind->PcoInfoLength);

	for (int idx = 0; idx < pApnOpReservedPcoListChange_ind->PcoInfoLength; ++idx)
	{
		printf("  PCO ID:  %d", pApnOpReservedPcoListChange_ind->pWdsApnOpReservedPcoList->PcoId);
		printf("  MCC:  %d", pApnOpReservedPcoListChange_ind->pWdsApnOpReservedPcoList->Mcc);
		printf("  MNC:  %d", pApnOpReservedPcoListChange_ind->pWdsApnOpReservedPcoList->Mnc);
		printf("  MNC Includes PCS Digit:  %d", pApnOpReservedPcoListChange_ind->pWdsApnOpReservedPcoList->MncIncludesPcsDigit);
		printf("  APP Specific Info Length:  %d", pApnOpReservedPcoListChange_ind->pWdsApnOpReservedPcoList->AppSpecificInfoLength);
		printf("  App Specific Info:");
		pAppSpecificInfo = pApnOpReservedPcoListChange_ind->pWdsApnOpReservedPcoList->AppSpecificInfo;
		for (int idy = 0; idy < pApnOpReservedPcoListChange_ind->pWdsApnOpReservedPcoList->AppSpecificInfoLength; ++idy)
		{
			printf("%d", *pAppSpecificInfo);
			++pAppSpecificInfo;
		}
		printf("  Container ID:  %d", pApnOpReservedPcoListChange_ind->pWdsApnOpReservedPcoList->ContainerId);
	}
}

void DisplayApnMsisdnInfoChangeIndication(unpack_wds_SLQSApnMsisdnInfoChange_ind_t *pApnMsisdnInfoChange_ind)
{
	printf("\n  APN MSISDN Info Change Indicationn");
	printf("    Apn Name: %s\n", pApnMsisdnInfoChange_ind->apn_name);
	printf("    MSISDN Count: %d\n", pApnMsisdnInfoChange_ind->msisdn_len);
	for (int idx = 0; idx < pApnMsisdnInfoChange_ind->msisdn_len; ++idx)
	{
		printf("  MSISDN:  %d\n", *pApnMsisdnInfoChange_ind->pMsisdn);
	}	
}

void DisplayPdnThrottleInfoIndication(unpack_wds_SLQSPdnThrottleInfo_ind_t *pPdnThrottleInfo_ind)
{
	printf("\n  PDN Throttle Info Indication\n");

	if (swi_uint256_get_bit (pPdnThrottleInfo_ind->ParamPresenceMask, 0x10))
	{
		printf("  Throttle Info Count:  %d\n", pPdnThrottleInfo_ind->throttle_info_len);	
		for (int idx = 0; idx < pPdnThrottleInfo_ind->throttle_info_len; ++idx)
		{
			printf("  Is IPv4 Throttled:  %d\n", pPdnThrottleInfo_ind->pPDNThrottleInformation->is_ipv4_throttled);
			printf("  Is IPv6 Throttled:  %d\n", pPdnThrottleInfo_ind->pPDNThrottleInformation->is_ipv6_throttled);
			printf("  Remaining IPv4 Throttled time:  %d\n", pPdnThrottleInfo_ind->pPDNThrottleInformation->remaining_ipv4_throttled_time);
			printf("  Remaining IPv6 Throttled time:  %d\n", pPdnThrottleInfo_ind->pPDNThrottleInformation->remaining_ipv6_throttled_time);
			printf("  APN Name:  %s\n", pPdnThrottleInfo_ind->pPDNThrottleInformation->ApnName);
		}
	}	
	
	if (swi_uint256_get_bit (pPdnThrottleInfo_ind->ParamPresenceMask, 0x11))
	{
		printf("  Throttle Info Extended Count:  %d\n", pPdnThrottleInfo_ind->throttle_info_ext_len);
		for (int idx = 0; idx < pPdnThrottleInfo_ind->throttle_info_len; ++idx)
		{
			printf("  Is IPv4 Throttled:  %d\n", pPdnThrottleInfo_ind->pExtPDNThrottleInformationList->is_ipv4_throttled);
			printf("  Is IPv6 Throttled:  %d\n", pPdnThrottleInfo_ind->pExtPDNThrottleInformationList->is_ipv6_throttled);
			printf("  Is Non-IP Throttled:  %d\n", pPdnThrottleInfo_ind->pExtPDNThrottleInformationList->is_non_ip_throttled);
			printf("  Remaining IPv4 Throttled time:  %d\n", pPdnThrottleInfo_ind->pExtPDNThrottleInformationList->remaining_ipv4_throttled_time);
			printf("  Remaining IPv6 Throttled time:  %d\n", pPdnThrottleInfo_ind->pExtPDNThrottleInformationList->remaining_ipv6_throttled_time);
			printf("  Remaining Non-IP Throttled time:  %d\n", pPdnThrottleInfo_ind->pExtPDNThrottleInformationList->remaining_non_ip_throttled_time);
			printf("  APN Name:  %s\n", pPdnThrottleInfo_ind->pExtPDNThrottleInformationList->ApnName);
		}
	}

	if (swi_uint256_get_bit (pPdnThrottleInfo_ind->ParamPresenceMask, 0x12))
	{
		printf("  Throttle Info Additional Params Count:  %d\n", pPdnThrottleInfo_ind->throttle_info_addn_params_len);
		for (int idx = 0; idx < pPdnThrottleInfo_ind->throttle_info_len; ++idx)
		{
			printf("  Is Emergency APN:  %d\n", pPdnThrottleInfo_ind->pAddPDNThrottleInformationList->is_emergency_apn);
			printf("  APN Blocked Oon All Plmns:  %d\n", pPdnThrottleInfo_ind->pAddPDNThrottleInformationList->apn_blocked_on_all_plmns);
			printf("  throttled_plmn_id:  %d", pPdnThrottleInfo_ind->pAddPDNThrottleInformationList->throttled_plmn_id[0]);
			printf("%d", pPdnThrottleInfo_ind->pAddPDNThrottleInformationList->throttled_plmn_id[1]);
			printf("%d\n", pPdnThrottleInfo_ind->pAddPDNThrottleInformationList->throttled_plmn_id[2]);
			printf("  APN Name:  %s\n", pPdnThrottleInfo_ind->pAddPDNThrottleInformationList->ApnName);
		}
	}
}

void DisplayModemAssistedKaStatusIndication(unpack_wds_SLQSModemAssistedKaStatus_ind_t  *pModemAssistedKaStatus_ind)
{
	printf("\n  Modem Assisted Keep-Alive Status Indication\n");
	printf("  	Status:  %d\n", pModemAssistedKaStatus_ind->Status);
	printf("  	Keep-Alive Handle:  %d\n", pModemAssistedKaStatus_ind->Keep_alive_handle);
}

void DisplayWdsEventReport(unpack_wds_SLQSSetWdsEventReport_ind_t *pWdsEventReport_ind)
{
	printf("\n  WDS Event Report Indication\n");
	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x10))
		printf("  	tx_ok_count:  %d\n", pWdsEventReport_ind->tx_ok_count);
	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x11))
		printf("  	rx_ok_count:  %d\n", pWdsEventReport_ind->rx_ok_count);
	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x12))
		printf("  	tx_err_count:  %d\n", pWdsEventReport_ind->tx_err_count);
	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x13))
		printf("  	rx_err_count:  %d\n", pWdsEventReport_ind->rx_err_count);
	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x14))
		printf("  	pTx_ofl_count:  %d\n", pWdsEventReport_ind->pTx_ofl_count);
	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x15))
		printf("  	rx_ofl_count:  %d\n", pWdsEventReport_ind->rx_ofl_count);
	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x18))
		printf("  	dormancy_status:  %d\n", pWdsEventReport_ind->dormancy_status);
	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x19))
		printf("  	tx_ok_bytes_count:  0x%"PRIX64"\n", pWdsEventReport_ind->tx_ok_bytes_count);
	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x1A))
		printf("  	rx_ok_bytes_count:  0x%"PRIX64"\n", pWdsEventReport_ind->rx_ok_bytes_count);
	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x1B))
		printf("  	mip_status:  %d\n", pWdsEventReport_ind->mip_status);
	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x1F))
		printf("  	data_call_status:  %d\n", pWdsEventReport_ind->data_call_status);
	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x20))
		printf("  	current_sys:  %d\n", pWdsEventReport_ind->current_sys);

	//DataCallTypeTlv_t               dataCallType; //22
	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x22))
	{
		printf("  	dataCallType.data_call_type:  %d\n", pWdsEventReport_ind->dataCallType.data_call_type);
    	printf("  	dataCallType.tethered_call_type:  %d\n", pWdsEventReport_ind->dataCallType.tethered_call_type);
	}

	//EVDOPageMonitorPeriodChange_t   eVDOPageMonitorPeriodChange; //23
	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x23))
	{
		printf("  	eVDOPageMonitorPeriodChange.evdo_page_monitor_period_change:  %d\n", pWdsEventReport_ind->eVDOPageMonitorPeriodChange.evdo_page_monitor_period_change);
    	printf("  	eVDOPageMonitorPeriodChange.evdo_force_long_sleep:  %d\n", pWdsEventReport_ind->eVDOPageMonitorPeriodChange.evdo_force_long_sleep);
	}

	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x25))
		printf("  	tx_dropped_count:  %d\n", pWdsEventReport_ind->tx_dropped_count);
	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x26))
		printf("  	rx_dropped_count:  %d\n", pWdsEventReport_ind->rx_dropped_count);
	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x27))
		printf("  	uplink_flow_control:  %d\n", pWdsEventReport_ind->uplink_flow_control); 
	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x28))
		printf("  	data_call_addr_family:  %d\n", pWdsEventReport_ind->data_call_addr_family);
	
	//AdditionalPdnFiltersRemoved_t   additionalPdnFiltersRemoved; //29
	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x29))
	{
		for (int idx = 0; idx < pWdsEventReport_ind->additionalPdnFiltersRemoved.removed_filter_handles_len; ++idx)
		{
			printf("  	additionalPdnFiltersRemoved.removed_filter_handles[%d]:  %d\n", idx, pWdsEventReport_ind->additionalPdnFiltersRemoved.removed_filter_handles[idx]); 
		}
	}

	//DataBearerTechnologyExtended_t  dataBearerTechnologyExtended; //2A
	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x2A))
	{
		printf("  	dataBearerTechnologyExtended.technology:  %d\n", pWdsEventReport_ind->dataBearerTechnologyExtended.technology);
		printf("  	dataBearerTechnologyExtended.rat_value:  %d\n", pWdsEventReport_ind->dataBearerTechnologyExtended.rat_value);
		printf("  	dataBearerTechnologyExtended.so_mask:  0x%"PRIX64"\n", pWdsEventReport_ind->dataBearerTechnologyExtended.so_mask);
	}

	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x2B))
		printf("  	uplink_fc_seq_num:  %d\n", pWdsEventReport_ind->uplink_fc_seq_num);  //2B

	//DormancyResultIndicator_t       dormancyResultIndicator; //2C
	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x2C))
	{
		printf("  	dormancyResultIndicator.status:  %d\n", pWdsEventReport_ind->dormancyResultIndicator.status);
		printf("  	dormancyResultIndicator.dormancy_failure_reason:  %d\n", pWdsEventReport_ind->dormancyResultIndicator.dormancy_failure_reason);
	}

	//ExtendedChannelRate_t           extendedChannelRate; //2D
	if (swi_uint256_get_bit (pWdsEventReport_ind->ParamPresenceMask, 0x2D))
	{	
		printf("  	extendedChannelRate.rate_type:  %d\n", pWdsEventReport_ind->extendedChannelRate.rate_type);
		printf("  	extendedChannelRate.channel_tx_rate_ex:  0x%"PRIX64"\n", pWdsEventReport_ind->extendedChannelRate.channel_tx_rate_ex);
		printf("  	extendedChannelRate.channel_rx_rate_ex:  0x%"PRIX64"\n", pWdsEventReport_ind->extendedChannelRate.channel_rx_rate_ex);
	}
}

void Display3GPPConfigItems(unpack_wds_SLQSGet3GPPConfigItem_t *pGet3GPPConfigItem)
{
	printf("\n  3GPP Configuration Items\n");

	if (swi_uint256_get_bit (pGet3GPPConfigItem->ParamPresenceMask, 0x10))
	{	
		printf("  	LTEAttachProfile:  %d\n", pGet3GPPConfigItem->LTEAttachProfile);
	}
	if (swi_uint256_get_bit (pGet3GPPConfigItem->ParamPresenceMask, 0x11))
	{	
		for (int idx = 0; idx < 4; ++idx)
		{
			printf("  	profileList[%d]:  %d\n", idx, pGet3GPPConfigItem->profileList[idx]);
		}
	}
	if (swi_uint256_get_bit (pGet3GPPConfigItem->ParamPresenceMask, 0x12))
	{	
		printf("  	defaultPDNEnabled:  %d\n", pGet3GPPConfigItem->defaultPDNEnabled);
	}
	if (swi_uint256_get_bit (pGet3GPPConfigItem->ParamPresenceMask, 0x13))
	{	
		printf("  	_3gppRelease:  %d\n", pGet3GPPConfigItem->_3gppRelease);
	}
	if (swi_uint256_get_bit (pGet3GPPConfigItem->ParamPresenceMask, 0x14))
	{	
		for (int idx = 0; idx < pGet3GPPConfigItem->LTEAttachProfileListLen; ++idx)
		{
			printf("  	LTEAttachProfileList[%d]:  %d\n", idx, pGet3GPPConfigItem->LTEAttachProfileList[idx]);
		}
	}
}

void DisplayThroughputInformationInd(unpack_wds_ThroughputInformationInd_t  *pThroughputInformationInd)
{
	printf("\n  Throughput Information Indication\n");

	if (swi_uint256_get_bit (pThroughputInformationInd->ParamPresenceMask, 0x10))
	{	
		printf("  	Throughput information count:  %d\n", pThroughputInformationInd->throughput_info_len);
		ThroughputInformationItem_t *pThroughputInformationList = pThroughputInformationInd->pThroughputInformationList;
		ThroughputInformationMac_t *pThroughputInformationMac = NULL;
		for (int idx = 0; idx < pThroughputInformationInd->throughput_info_len; ++idx)
		{
			printf("    ThroughputInformation[%d]->Apn: %s", idx, pThroughputInformationList->apn_string);
			printf("    ThroughputInformation[%d]->ip_type: %d", idx, pThroughputInformationList->ip_type);
			printf("    ThroughputInformation[%d]->tech_type: %d", idx, pThroughputInformationList->tech_type);
  			printf("    ThroughputInformation[%d]->subscription: %d", idx, pThroughputInformationList->subscription);
   			printf("    ThroughputInformation[%d]->uplink_actual_rate: %d", idx, pThroughputInformationList->uplink_actual_rate);
   			printf("    ThroughputInformation[%d]->uplink_allowed_rate: %d", idx, pThroughputInformationList->uplink_allowed_rate);
   			printf("    ThroughputInformation[%d]->uplink_queue_size: %d", idx, pThroughputInformationList->uplink_queue_size);
   			printf("    ThroughputInformation[%d]->throughput_signal: %d", idx, pThroughputInformationList->throughput_signal);
  			printf("    ThroughputInformation[%d]->valid_port: %d", idx, pThroughputInformationList->valid_port);
  			printf("    ThroughputInformation[%d]->data_port: %d", idx, pThroughputInformationList->data_port);
  			printf("    ThroughputInformation[%d]->ep_type: %d", idx, pThroughputInformationList->ep_type);
			printf("    ThroughputInformation[%d]->iface_id: %d", idx, pThroughputInformationList->iface_id);
  			printf("    ThroughputInformation[%d]->mux_id: %d", idx, pThroughputInformationList->mux_id);

  			printf("    ThroughputInformation[%d]->bearer_rlp_mac_id_throughput_info_len: %d", idx, pThroughputInformationList->bearer_rlp_mac_id_throughput_info_len);
  			pThroughputInformationMac = pThroughputInformationList->pThroughputInformationMac;
			for (int idy = 0; idy < pThroughputInformationList->bearer_rlp_mac_id_throughput_info_len; ++idy)
			{
  				printf("      ThroughputInformation[%d][%d]->bearer_rlp_mac_id: %d", idx, idy, pThroughputInformationMac->bearer_rlp_mac_id);
  				printf("      ThroughputInformation[%d][%d]->uplink_actual_rate: %d", idx, idy, pThroughputInformationMac->uplink_actual_rate);
  				printf("      ThroughputInformation[%d][%d]->uplink_queue_size: %d", idx, idy, pThroughputInformationMac->uplink_queue_size);
  				printf("      ThroughputInformation[%d][%d]->is_primary: %d", idx, idy, pThroughputInformationMac->is_primary); 
				++pThroughputInformationMac;
			}
			++pThroughputInformationList;
		}

	}
}

void DisplayDownlinkThroughputInformationInd(unpack_wds_DLThroughputInformationInd_t  *pDLThroughputInfoInd)
{
	printf("\n  Downlink Throughput Information Indication\n");

	if (swi_uint256_get_bit (pDLThroughputInfoInd->ParamPresenceMask, 0x10))
	{
		printf("  	Downlink_allowed_rate:  %d\n", *pDLThroughputInfoInd->pDownlink_allowed_rate);
	}
	if (swi_uint256_get_bit (pDLThroughputInfoInd->ParamPresenceMask, 0x11))
	{
		printf("  	Confidence_level:  %d\n", *pDLThroughputInfoInd->pConfidence_level);
	}
	if (swi_uint256_get_bit (pDLThroughputInfoInd->ParamPresenceMask, 0x12))
	{
		printf("  	Is_suspended:  %d\n", *pDLThroughputInfoInd->pIs_suspended);
	}

}
void DisplayQueryDLThroughputReportingStatus(unpack_wds_QueryDLThroughputReportingStatusInd_t  *pQueryDLThroughputReportingStatusInd)
{
	printf("\n  Query Downlink Throughput Reporting Status Indication\n");

	if (swi_uint256_get_bit (pQueryDLThroughputReportingStatusInd->ParamPresenceMask, 0x10))
	{
		switch(*pQueryDLThroughputReportingStatusInd->pReporting_status)
		{
			case 0:
				printf("  	Reporting_status:  Throughput reporting enabled\n");
			break;
			case 1:
				printf("  	Reporting_status:  No data call\n");
			break;
			case 2:
				printf("  	Reporting_status:  All calls dormant\n");
			break;
			case 3:
				printf("  	Reporting_status:  Unsupported RAT\n");
			break;
			default:
				printf("  	Reporting_status:  Returned value Unknown\n");
			break;
		}
	}
	if (swi_uint256_get_bit (pQueryDLThroughputReportingStatusInd->ParamPresenceMask, 0x11))
	{
		printf("  	Actual Interval:  %d\n", *pQueryDLThroughputReportingStatusInd->pActual_interval);
	}
}

void DisplayGetCurrentChannelRate(unpack_wds_SLQSGetCurrentChannelRate_t *pCurrentChannelRate)
{
	printf("\n  Get Current Channel Rate\n");

	if (swi_uint256_get_bit (pCurrentChannelRate->ParamPresenceMask, 0x01))
	{
		printf("  	current channel tx rate:  %d\n", pCurrentChannelRate->current_channel_tx_rate);
		printf("  	current channel rx rate:  %d\n", pCurrentChannelRate->current_channel_rx_rate);
		printf("  	max channel tx rate:  %d\n", pCurrentChannelRate->max_channel_tx_rate);
		printf("  	max channel rx rate:  %d\n", pCurrentChannelRate->max_channel_rx_rate);
	}
}
